/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;

public class PutFromLoadValidator {
    public static final long NAKED_PUT_INVALIDATION_PERIOD = TimeUnit.SECONDS.toMillis(20L);
    private static final long PENDING_PUT_OVERAGE_PERIOD = TimeUnit.SECONDS.toMillis(5L);
    private static final long PENDING_PUT_RECENT_PERIOD = TimeUnit.SECONDS.toMillis(2L);
    private static final long MAX_PENDING_PUT_DELAY = TimeUnit.SECONDS.toMillis(120L);
    private final TransactionManager transactionManager;
    private final long nakedPutInvalidationPeriod;
    private final long pendingPutOveragePeriod;
    private final long pendingPutRecentPeriod;
    private final long maxPendingPutDelay;
    private final ConcurrentMap<Object, PendingPutMap> pendingPuts = new ConcurrentHashMap<Object, PendingPutMap>();
    private final List<WeakReference<PendingPut>> pendingQueue = new LinkedList<WeakReference<PendingPut>>();
    private final List<WeakReference<PendingPut>> overagePendingQueue = new LinkedList<WeakReference<PendingPut>>();
    private final Lock pendingLock = new ReentrantLock();
    private final ConcurrentMap<Object, Long> recentRemovals = new ConcurrentHashMap<Object, Long>();
    private final List<RecentRemoval> removalsQueue = new LinkedList<RecentRemoval>();
    private volatile long earliestRemovalTimestamp;
    private final Lock removalsLock = new ReentrantLock();
    private volatile long invalidationTimestamp;

    public PutFromLoadValidator(TransactionManager transactionManager) {
        this(transactionManager, NAKED_PUT_INVALIDATION_PERIOD, PENDING_PUT_OVERAGE_PERIOD, PENDING_PUT_RECENT_PERIOD, MAX_PENDING_PUT_DELAY);
    }

    protected PutFromLoadValidator(TransactionManager transactionManager, long nakedPutInvalidationPeriod, long pendingPutOveragePeriod, long pendingPutRecentPeriod, long maxPendingPutDelay) {
        this.transactionManager = transactionManager;
        this.nakedPutInvalidationPeriod = nakedPutInvalidationPeriod;
        this.pendingPutOveragePeriod = pendingPutOveragePeriod;
        this.pendingPutRecentPeriod = pendingPutRecentPeriod;
        this.maxPendingPutDelay = maxPendingPutDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquirePutFromLoadLock(Object key) {
        boolean valid;
        block12: {
            valid = false;
            boolean locked = false;
            long now = System.currentTimeMillis();
            this.cleanOutdatedPendingPuts(now, true);
            try {
                Long removedTime;
                PendingPutMap pending = (PendingPutMap)this.pendingPuts.get(key);
                if (pending != null) {
                    locked = pending.acquireLock(100L, TimeUnit.MILLISECONDS);
                    if (!locked) break block12;
                    try {
                        PendingPut toCancel = pending.remove(this.getOwnerForPut());
                        if (toCancel != null) {
                            valid = !toCancel.completed;
                            toCancel.completed = true;
                        }
                        break block12;
                    }
                    finally {
                        if (!valid) {
                            pending.releaseLock();
                            locked = false;
                        }
                    }
                }
                if (now > this.invalidationTimestamp && ((removedTime = (Long)this.recentRemovals.get(key)) == null || now > removedTime)) {
                    this.registerPendingPut(key);
                    valid = locked = this.acquirePutFromLoadLock(key);
                }
            }
            catch (Throwable t) {
                PendingPutMap toRelease;
                valid = false;
                if (locked && (toRelease = (PendingPutMap)this.pendingPuts.get(key)) != null) {
                    toRelease.releaseLock();
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
        }
        return valid;
    }

    public void releasePutFromLoadLock(Object key) {
        PendingPutMap pending = (PendingPutMap)this.pendingPuts.get(key);
        if (pending != null) {
            if (pending.size() == 0) {
                this.pendingPuts.remove(key, pending);
            }
            pending.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateKey(Object key) {
        Long cleaned;
        boolean success = true;
        PendingPutMap pending = (PendingPutMap)this.pendingPuts.get(key);
        if (pending != null) {
            if (pending.acquireLock(60L, TimeUnit.SECONDS)) {
                try {
                    pending.invalidate();
                }
                finally {
                    pending.releaseLock();
                }
            } else {
                success = false;
            }
        }
        RecentRemoval removal = new RecentRemoval(key, this.nakedPutInvalidationPeriod);
        this.recentRemovals.put(key, removal.timestamp);
        RecentRemoval toClean = null;
        boolean attemptClean = removal.timestamp > this.earliestRemovalTimestamp;
        this.removalsLock.lock();
        try {
            this.removalsQueue.add(removal);
            if (attemptClean) {
                if (this.removalsQueue.size() > 1) {
                    toClean = this.removalsQueue.remove(0);
                }
                this.earliestRemovalTimestamp = this.removalsQueue.get(0).timestamp;
            }
        }
        finally {
            this.removalsLock.unlock();
        }
        if (toClean != null && (cleaned = (Long)this.recentRemovals.get(toClean.key)) != null && cleaned.equals(toClean.timestamp) && (cleaned = (Long)this.recentRemovals.remove(toClean.key)) != null && !cleaned.equals(toClean.timestamp)) {
            this.recentRemovals.putIfAbsent(toClean.key, cleaned);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateRegion() {
        boolean ok = false;
        this.invalidationTimestamp = System.currentTimeMillis() + this.nakedPutInvalidationPeriod;
        try {
            for (PendingPutMap entry : this.pendingPuts.values()) {
                if (entry.acquireLock(60L, TimeUnit.SECONDS)) {
                    try {
                        entry.invalidate();
                        continue;
                    }
                    finally {
                        entry.releaseLock();
                        continue;
                    }
                }
                ok = false;
            }
            this.removalsLock.lock();
            try {
                this.recentRemovals.clear();
                this.removalsQueue.clear();
                ok = true;
            }
            finally {
                this.removalsLock.unlock();
            }
        }
        catch (Exception e) {
            ok = false;
        }
        finally {
            this.earliestRemovalTimestamp = this.invalidationTimestamp;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPendingPut(Object key) {
        PendingPutMap existing;
        PendingPut pendingPut = new PendingPut(key, this.getOwnerForPut());
        PendingPutMap pendingForKey = new PendingPutMap(pendingPut);
        while ((existing = this.pendingPuts.putIfAbsent(key, pendingForKey)) != null && existing.acquireLock(10L, TimeUnit.SECONDS)) {
            try {
                existing.put(pendingPut);
                PendingPutMap doublecheck = this.pendingPuts.putIfAbsent(key, existing);
                if (doublecheck != null && doublecheck != existing) continue;
                break;
            }
            finally {
                existing.releaseLock();
            }
        }
        this.preventOutdatedPendingPuts(pendingPut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPendingPutQueueLength() {
        this.pendingLock.lock();
        try {
            int n = this.pendingQueue.size();
            return n;
        }
        finally {
            this.pendingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getOveragePendingPutQueueLength() {
        this.pendingLock.lock();
        try {
            int n = this.overagePendingQueue.size();
            return n;
        }
        finally {
            this.pendingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRemovalQueueLength() {
        this.removalsLock.lock();
        try {
            int n = this.removalsQueue.size();
            return n;
        }
        finally {
            this.removalsLock.unlock();
        }
    }

    private Object getOwnerForPut() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.getTransaction();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not obtain transaction", (Throwable)se);
        }
        return tx == null ? Thread.currentThread() : tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preventOutdatedPendingPuts(PendingPut pendingPut) {
        this.pendingLock.lock();
        try {
            this.pendingQueue.add(new WeakReference<PendingPut>(pendingPut));
            if (this.pendingQueue.size() > 1) {
                this.cleanOutdatedPendingPuts(pendingPut.timestamp, false);
            }
        }
        finally {
            this.pendingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cleanOutdatedPendingPuts(long now, boolean lock) {
        PendingPutMap map;
        PendingPut toClean = null;
        if (lock) {
            this.pendingLock.lock();
        }
        try {
            long overaged = now - this.pendingPutOveragePeriod;
            long recent = now - this.pendingPutRecentPeriod;
            int pos = 0;
            while (this.pendingQueue.size() > pos) {
                WeakReference<PendingPut> ref = this.pendingQueue.get(pos);
                PendingPut item = (PendingPut)ref.get();
                if (item == null || item.completed) {
                    this.pendingQueue.remove(pos);
                    continue;
                }
                if (item.timestamp < overaged) {
                    this.pendingQueue.remove(pos);
                    this.overagePendingQueue.add(ref);
                    continue;
                }
                if (item.timestamp >= recent || pos > 2) break;
                ++pos;
            }
            long mustCleanTime = now - this.maxPendingPutDelay;
            while (this.overagePendingQueue.size() > 0) {
                WeakReference<PendingPut> ref = this.overagePendingQueue.get(0);
                PendingPut item = (PendingPut)ref.get();
                if (item == null || item.completed) {
                    this.overagePendingQueue.remove(0);
                    continue;
                }
                if (item.timestamp < mustCleanTime) {
                    this.overagePendingQueue.remove(0);
                    toClean = item;
                }
                break;
            }
        }
        finally {
            if (lock) {
                this.pendingLock.unlock();
            }
        }
        if (toClean == null || (map = (PendingPutMap)this.pendingPuts.get(toClean.key)) == null) return;
        if (map.acquireLock(100L, TimeUnit.MILLISECONDS)) {
            try {
                PendingPut cleaned = map.remove(toClean.owner);
                if (!toClean.equals(cleaned)) {
                    if (cleaned == null) return;
                    map.put(cleaned);
                    return;
                }
                if (map.size() != 0) return;
                this.pendingPuts.remove(toClean.key, map);
                return;
            }
            finally {
                map.releaseLock();
            }
        } else {
            this.restorePendingPut(toClean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorePendingPut(PendingPut toRestore) {
        this.pendingLock.lock();
        try {
            toRestore.refresh();
            this.pendingQueue.add(new WeakReference<PendingPut>(toRestore));
        }
        finally {
            this.pendingLock.unlock();
        }
    }

    private static class RecentRemoval {
        private final Object key;
        private final Long timestamp;

        private RecentRemoval(Object key, long nakedPutInvalidationPeriod) {
            this.key = key;
            this.timestamp = System.currentTimeMillis() + nakedPutInvalidationPeriod;
        }
    }

    private static class PendingPut {
        private final Object key;
        private final Object owner;
        private long timestamp = System.currentTimeMillis();
        private volatile boolean completed;

        private PendingPut(Object key, Object owner) {
            this.key = key;
            this.owner = owner;
        }

        private void refresh() {
            this.timestamp = System.currentTimeMillis();
        }
    }

    private static class PendingPutMap {
        private PendingPut singlePendingPut;
        private Map<Object, PendingPut> fullMap;
        private final Lock lock = new ReentrantLock();

        PendingPutMap(PendingPut singleItem) {
            this.singlePendingPut = singleItem;
        }

        public void put(PendingPut pendingPut) {
            if (this.singlePendingPut == null) {
                if (this.fullMap == null) {
                    this.singlePendingPut = pendingPut;
                } else {
                    this.fullMap.put(pendingPut.owner, pendingPut);
                }
            } else {
                this.fullMap = new HashMap<Object, PendingPut>(4);
                this.fullMap.put(this.singlePendingPut.owner, this.singlePendingPut);
                this.singlePendingPut = null;
                this.fullMap.put(pendingPut.owner, pendingPut);
            }
        }

        public PendingPut remove(Object ownerForPut) {
            PendingPut removed = null;
            if (this.fullMap == null) {
                if (this.singlePendingPut != null && this.singlePendingPut.owner.equals(ownerForPut)) {
                    removed = this.singlePendingPut;
                    this.singlePendingPut = null;
                }
            } else {
                removed = this.fullMap.remove(ownerForPut);
            }
            return removed;
        }

        public int size() {
            return this.fullMap == null ? (this.singlePendingPut == null ? 0 : 1) : this.fullMap.size();
        }

        public boolean acquireLock(long time, TimeUnit unit) {
            try {
                return this.lock.tryLock(time, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        public void releaseLock() {
            this.lock.unlock();
        }

        public void invalidate() {
            if (this.singlePendingPut != null) {
                this.singlePendingPut.completed = true;
                this.singlePendingPut = null;
            } else if (this.fullMap != null) {
                for (PendingPut pp : this.fullMap.values()) {
                    pp.completed = true;
                }
                this.fullMap = null;
            }
        }
    }
}

