/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.lock;

import java.io.Serializable;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.ClusteringApiLogger;
import org.jboss.as.clustering.ClusteringApiMessages;
import org.jboss.as.clustering.GroupMembershipNotifier;
import org.jboss.as.clustering.GroupRpcDispatcher;
import org.jboss.as.clustering.lock.AbstractClusterLockSupport;
import org.jboss.as.clustering.lock.ClusterLockState;
import org.jboss.as.clustering.lock.LocalLockHandler;
import org.jboss.as.clustering.lock.RemoteLockResponse;
import org.jboss.as.clustering.lock.TimeoutException;

public class YieldingGloballyExclusiveClusterLockSupport
extends AbstractClusterLockSupport {
    public YieldingGloballyExclusiveClusterLockSupport(String serviceHAName, GroupRpcDispatcher rpcDispatcher, GroupMembershipNotifier membershipNotifier, LocalLockHandler handler) {
        super(serviceHAName, rpcDispatcher, membershipNotifier, handler);
    }

    @Override
    public void unlock(Serializable lockId) {
        ClusterNode myself = this.getLocalClusterNode();
        if (myself == null) {
            throw ClusteringApiMessages.MESSAGES.invalidMethodCall("start()", "unlock()");
        }
        ClusterLockState category = this.getClusterLockState(lockId, false);
        if (category == null) {
            this.getLocalHandler().unlockFromCluster(lockId, myself);
        } else if (myself.equals(category.getHolder())) {
            category.invalidate();
            this.getLocalHandler().unlockFromCluster(lockId, myself);
            this.removeLockState(category);
        }
    }

    @Override
    protected ClusterLockState getClusterLockState(Serializable categoryName) {
        return this.getClusterLockState(categoryName, false);
    }

    @Override
    protected RemoteLockResponse yieldLock(ClusterLockState lockState, ClusterNode caller, long timeout) {
        if (this.getLocalClusterNode().equals(lockState.getHolder())) {
            return this.getLock(lockState.lockId, lockState, caller, timeout);
        }
        return new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.REJECT, lockState.getHolder());
    }

    @Override
    protected RemoteLockResponse handleLockSuccess(ClusterLockState lockState, ClusterNode caller) {
        if (this.getLocalClusterNode().equals(caller)) {
            this.recordLockHolder(lockState, caller);
        } else {
            lockState.invalidate();
            this.removeLockState(lockState);
        }
        return new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.OK);
    }

    @Override
    protected RemoteLockResponse getRemoteLockResponseForUnknownLock(Serializable lockName, ClusterNode caller, long timeout) {
        RemoteLockResponse response;
        try {
            this.getLocalHandler().lockFromCluster(lockName, caller, timeout);
            return new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.OK);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ClusteringApiLogger.ROOT_LOGGER.caughtInterruptedException(caller, lockName);
            response = new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.FAIL, this.getLocalHandler().getLockHolder(lockName));
        }
        catch (TimeoutException t) {
            response = new RemoteLockResponse(this.getLocalClusterNode(), RemoteLockResponse.Flag.FAIL, t.getOwner());
        }
        return response;
    }
}

