/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.lock;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.ClusteringApiMessages;

public class ClusterLockState {
    final Serializable lockId;
    final AtomicReference<State> state = new AtomicReference<State>(State.UNLOCKED);
    ClusterNode holder;

    ClusterLockState(Serializable lockId) {
        if (lockId == null) {
            throw ClusteringApiMessages.MESSAGES.nullVar("lockId");
        }
        this.lockId = lockId;
    }

    public synchronized ClusterNode getHolder() {
        return this.holder;
    }

    public synchronized void invalidate() {
        this.state.set(State.INVALID);
        this.holder = null;
    }

    public synchronized void lock(ClusterNode holder) {
        this.state.set(State.LOCKED);
        this.holder = holder;
    }

    public synchronized void release() {
        if (this.state.compareAndSet(State.LOCKED, State.UNLOCKED)) {
            this.holder = null;
        }
    }

    public static enum State {
        UNLOCKED,
        REMOTE_LOCKING,
        LOCAL_LOCKING,
        LOCKED,
        INVALID;

    }
}

