/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.jacoco.client;

import java.util.Map;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.extension.jacoco.client.InstrumenterAsset;
import org.jboss.arquillian.extension.jacoco.client.JacocoConfiguration;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationArchiveInstrumenter
implements ApplicationArchiveProcessor {
    @Inject
    private Instance<JacocoConfiguration> config;

    private void processArchive(Archive<?> archive, Filter<ArchivePath> filter) {
        Map classes = archive.getContent(filter);
        for (Map.Entry entry : classes.entrySet()) {
            Asset original = ((Node)entry.getValue()).getAsset();
            archive.delete((ArchivePath)entry.getKey());
            archive.add((Asset)new InstrumenterAsset(original), (ArchivePath)entry.getKey());
        }
        Map jars = archive.getContent(Filters.include((String)".*\\.(jar|war|rar|ear)$"));
        for (Map.Entry entry : jars.entrySet()) {
            JavaArchive subArchive = (JavaArchive)archive.getAsType(JavaArchive.class, (ArchivePath)entry.getKey());
            this.processArchive((Archive<?>)subArchive, filter);
        }
    }

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        this.processArchive(applicationArchive, ((JacocoConfiguration)this.config.get()).getClassFilter());
    }
}

