/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.CacheException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.util.Util;

public abstract class AbstractJmxRegistration {
    String jmxDomain;
    MBeanServer mBeanServer;
    GlobalConfiguration globalConfig;

    protected abstract ComponentsJmxRegistration buildRegistrar(Set<AbstractComponentRegistry.Component> var1);

    protected void registerMBeans(Set<AbstractComponentRegistry.Component> components, GlobalConfiguration globalConfig) {
        this.mBeanServer = this.getMBeanServer(globalConfig);
        ComponentsJmxRegistration registrar = this.buildRegistrar(components);
        registrar.registerMBeans();
    }

    protected void unregisterMBeans(Set<AbstractComponentRegistry.Component> components) {
        if (this.mBeanServer != null) {
            ComponentsJmxRegistration registrar = this.buildRegistrar(components);
            registrar.unregisterMBeans();
        }
    }

    protected MBeanServer getMBeanServer(GlobalConfiguration configuration) {
        String serverLookup = configuration.getMBeanServerLookup();
        MBeanServerLookup lookup = (MBeanServerLookup)Util.getInstance(serverLookup);
        return lookup.getMBeanServer();
    }

    protected String getJmxDomain(String jmxDomain, MBeanServer mBeanServer, String groupName) {
        int index = 2;
        String finalName = jmxDomain;
        boolean done = false;
        while (!done) {
            done = true;
            try {
                ObjectName targetName = new ObjectName(finalName + ':' + groupName + ",*");
                if (mBeanServer.queryNames(targetName, null).size() <= 0) continue;
                finalName = jmxDomain + index++;
                done = false;
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException("Unable to check for duplicate names", e);
            }
        }
        return finalName;
    }
}

