/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.InvertedLeaveTask;
import org.infinispan.distribution.JoinTask;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.distribution.TransactionLoggerImpl;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.distribution.ch.NodeTopologyInfo;
import org.infinispan.distribution.ch.TopologyInfo;
import org.infinispan.distribution.ch.UnionConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.MembershipArithmetic;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;
import org.rhq.helpers.pluginAnnotations.agent.Parameter;

@MBean(objectName="DistributionManager", description="Component that handles distribution of content across a cluster")
public class DistributionManagerImpl
implements DistributionManager {
    private final Log log = LogFactory.getLog(DistributionManagerImpl.class);
    private Configuration configuration;
    private volatile ConsistentHash consistentHash;
    private volatile ConsistentHash oldConsistentHash;
    private Address self;
    private CacheLoaderManager cacheLoaderManager;
    RpcManager rpcManager;
    private CacheManagerNotifier notifier;
    private ViewChangeListener listener;
    private CommandsFactory cf;
    private final ExecutorService rehashExecutor;
    private final TransactionLogger transactionLogger = new TransactionLoggerImpl();
    TopologyInfo topologyInfo = new TopologyInfo();
    volatile boolean rehashInProgress = false;
    private volatile Address joiner;
    private static final AtomicReferenceFieldUpdater<DistributionManagerImpl, Address> JOINER_CAS = AtomicReferenceFieldUpdater.newUpdater(DistributionManagerImpl.class, Address.class, "joiner");
    private DataContainer dataContainer;
    private InterceptorChain interceptorChain;
    private InvocationContextContainer icc;
    @ManagedAttribute(description="If true, the node has successfully joined the grid and is considered to hold state.  If false, the join process is still in progress.")
    @Metric(displayName="Is join completed?", dataType=DataType.TRAIT)
    private volatile boolean joinComplete = false;
    private Future<Void> joinFuture;
    private final List<Address> leavers = new CopyOnWriteArrayList<Address>();
    private volatile Future<Void> leaveTaskFuture;
    private final ReclosableLatch startLatch = new ReclosableLatch(false);

    public DistributionManagerImpl() {
        LinkedBlockingQueue<Runnable> rehashQueue = new LinkedBlockingQueue<Runnable>();
        ThreadFactory tf = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setPriority(1);
                t.setName("Rehasher-" + DistributionManagerImpl.this.rpcManager.getTransport().getAddress());
                return t;
            }
        };
        this.rehashExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, rehashQueue, tf);
    }

    @Inject
    public void init(Configuration configuration, RpcManager rpcManager, CacheManagerNotifier notifier, CommandsFactory cf, DataContainer dataContainer, InterceptorChain interceptorChain, InvocationContextContainer icc, CacheLoaderManager cacheLoaderManager) {
        this.cacheLoaderManager = cacheLoaderManager;
        this.configuration = configuration;
        this.rpcManager = rpcManager;
        this.notifier = notifier;
        this.cf = cf;
        this.dataContainer = dataContainer;
        this.interceptorChain = interceptorChain;
        this.icc = icc;
    }

    @Start(priority=20)
    public void start() throws Exception {
        this.log.trace("Starting distribution manager on " + this.getMyAddress());
        this.listener = new ViewChangeListener();
        this.notifier.addListener(this.listener);
        GlobalConfiguration gc = this.configuration.getGlobalConfiguration();
        if (gc.hasTopologyInfo()) {
            Address address = this.rpcManager.getTransport().getAddress();
            NodeTopologyInfo nti = new NodeTopologyInfo(gc.getMachineId(), gc.getRackId(), gc.getSiteId(), address);
            this.topologyInfo.addNodeTopologyInfo(address, nti);
        }
        this.join();
    }

    private int getReplCount() {
        return this.configuration.getNumOwners();
    }

    private Address getMyAddress() {
        return this.rpcManager != null ? this.rpcManager.getAddress() : null;
    }

    @Start(priority=1000)
    public void waitForJoinToComplete() throws Throwable {
        if (this.joinFuture != null) {
            try {
                this.joinFuture.get();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
    }

    private void join() throws Exception {
        this.startLatch.close();
        this.setJoinComplete(false);
        Transport t = this.rpcManager.getTransport();
        List<Address> members = t.getMembers();
        this.consistentHash = ConsistentHashHelper.createConsistentHash(this.configuration, members, this.topologyInfo);
        this.self = t.getAddress();
        if (members.size() > 1 && !t.getCoordinator().equals(this.self)) {
            JoinTask joinTask = new JoinTask(this.rpcManager, this.cf, this.configuration, this.dataContainer, this);
            this.joinFuture = this.rehashExecutor.submit(joinTask);
        } else {
            this.setJoinComplete(true);
        }
        this.startLatch.open();
    }

    @Stop(priority=20)
    public void stop() {
        this.notifier.removeListener(this.listener);
        this.rehashExecutor.shutdownNow();
        this.setJoinComplete(false);
    }

    public void rehash(List<Address> newMembers, List<Address> oldMembers) {
        boolean join = oldMembers.size() < newMembers.size();
        this.log.info((Object)"Detected a view change.  Member list changed from {0} to {1}", oldMembers, newMembers);
        if (join) {
            Address joiner = MembershipArithmetic.getMemberJoined(oldMembers, newMembers);
            this.log.info("This is a JOIN event!  Wait for notification from new joiner " + joiner);
        } else {
            Address leaver = MembershipArithmetic.getMemberLeft(oldMembers, newMembers);
            this.log.info((Object)"This is a LEAVE event!  Node {0} has just left", leaver);
            try {
                this.oldConsistentHash = !(this.consistentHash instanceof UnionConsistentHash) ? this.consistentHash : ((UnionConsistentHash)this.consistentHash).getNewCH();
                this.consistentHash = ConsistentHashHelper.removeAddress(this.consistentHash, leaver, this.configuration, this.topologyInfo);
            }
            catch (Exception e) {
                this.log.fatal((Object)"Unable to process leaver!!", e);
                throw new CacheException(e);
            }
            List<Address> stateProviders = this.holdersOfLeaversState(leaver);
            boolean willReceiveLeaverState = this.willReceiveLeaverState(stateProviders);
            boolean willSendLeaverState = stateProviders.contains(this.self);
            if (willReceiveLeaverState || willSendLeaverState) {
                this.log.info((Object)"I {0} am participating in rehash", this.rpcManager.getTransport().getAddress());
                this.transactionLogger.enable();
                if (!(this.leaveTaskFuture == null || this.leaveTaskFuture.isCancelled() && this.leaveTaskFuture.isDone())) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Canceling running leave task!");
                    }
                    this.leaveTaskFuture.cancel(true);
                }
                this.leavers.add(leaver);
                InvertedLeaveTask task = new InvertedLeaveTask(this, this.rpcManager, this.configuration, this.cf, this.dataContainer, this.leavers, stateProviders, willReceiveLeaverState);
                this.leaveTaskFuture = this.rehashExecutor.submit(task);
            } else {
                this.log.info("Not in same subspace, so ignoring leave event");
                this.topologyInfo.removeNodeInfo(leaver);
            }
        }
    }

    List<Address> holdersOfLeaversState(Address leaver) {
        ArrayList<Address> result = new ArrayList<Address>();
        for (Address addr : this.oldConsistentHash.getCaches()) {
            List<Address> backups = this.oldConsistentHash.getBackupsForNode(addr, this.getReplCount());
            this.log.trace((Object)"Backups for {0} are {1}", addr, backups);
            if (addr.equals(leaver)) {
                if (backups.size() <= 1) continue;
                Address mainBackup = backups.get(1);
                result.add(mainBackup);
                this.log.trace((Object)"Leaver's ({0}) main backup({1}) is looking for another backup as well.", leaver, mainBackup);
                continue;
            }
            if (!backups.contains(leaver)) continue;
            this.log.trace((Object)"{0} is looking for a new backup to replace {1}", addr, leaver);
            result.add(addr);
        }
        this.log.trace((Object)"Nodes that need new backups are: {0}", result);
        return result;
    }

    boolean willReceiveLeaverState(List<Address> stateProviders) {
        for (Address addr : stateProviders) {
            List<Address> addressList = this.consistentHash.getBackupsForNode(addr, this.getReplCount());
            boolean isLast = addressList.indexOf(this.self) == addressList.size() - 1;
            if (!isLast) continue;
            this.log.trace((Object)"This is a new backup for {0}", addr);
            return true;
        }
        this.log.trace("This node won't receive state");
        return false;
    }

    @Override
    public boolean isLocal(Object key) {
        return this.consistentHash == null || this.consistentHash.isKeyLocalToAddress(this.self, key, this.getReplCount());
    }

    @Override
    public List<Address> locate(Object key) {
        if (this.consistentHash == null) {
            return Collections.singletonList(this.self);
        }
        return this.consistentHash.locate(key, this.getReplCount());
    }

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys) {
        return this.locateAll(keys, this.getReplCount());
    }

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys, int numOwners) {
        if (this.consistentHash == null) {
            HashMap<Object, List<Address>> m = new HashMap<Object, List<Address>>(keys.size());
            List<Address> selfList = Collections.singletonList(this.self);
            for (Object k : keys) {
                m.put(k, selfList);
            }
            return m;
        }
        return this.consistentHash.locateAll(keys, numOwners);
    }

    @Override
    public void transformForL1(CacheEntry entry) {
        if (entry.getLifespan() < 0L || entry.getLifespan() > this.configuration.getL1Lifespan()) {
            entry.setLifespan(this.configuration.getL1Lifespan());
        }
    }

    @Override
    public InternalCacheEntry retrieveFromRemoteSource(Object key) throws Exception {
        ClusteredGetCommand get = this.cf.buildClusteredGetCommand(key);
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(this.locate(key));
        List<Response> responses = this.rpcManager.invokeRemotely(this.locate(key), get, ResponseMode.SYNCHRONOUS, this.configuration.getSyncReplTimeout(), false, filter);
        if (!responses.isEmpty()) {
            for (Response r : responses) {
                if (!(r instanceof SuccessfulResponse)) continue;
                InternalCacheValue cacheValue = (InternalCacheValue)((SuccessfulResponse)r).getResponseValue();
                return cacheValue.toInternalCacheEntry(key);
            }
        }
        return null;
    }

    @Override
    public ConsistentHash getConsistentHash() {
        return this.consistentHash;
    }

    @Override
    public void setConsistentHash(ConsistentHash consistentHash) {
        this.log.trace((Object)"Installing new consistent hash {0}", consistentHash);
        this.consistentHash = consistentHash;
    }

    public void setOldConsistentHash(ConsistentHash oldConsistentHash) {
        this.oldConsistentHash = oldConsistentHash;
    }

    @Override
    @ManagedOperation(description="Determines whether a given key is affected by an ongoing rehash, if any.")
    @Operation(displayName="Could key be affected by rehash?")
    public boolean isAffectedByRehash(@Parameter(name="key", description="Key to check") Object key) {
        return this.transactionLogger.isEnabled() && this.oldConsistentHash != null && !this.oldConsistentHash.locate(key, this.getReplCount()).contains(this.self);
    }

    @Override
    public TransactionLogger getTransactionLogger() {
        return this.transactionLogger;
    }

    @Override
    public List<Address> requestPermissionToJoin(Address a) {
        if (JOINER_CAS.compareAndSet(this, null, a)) {
            this.log.trace((Object)"Allowing {0} to join", a);
            return new LinkedList<Address>(this.consistentHash.getCaches());
        }
        this.log.trace((Object)"Not alowing {0} to join since there is a join already in progress for node {1}", a, this.joiner);
        return null;
    }

    @Override
    public NodeTopologyInfo informRehashOnJoin(Address a, boolean starting, NodeTopologyInfo nodeTopologyInfo) {
        this.log.trace((Object)"Informed of a JOIN by {0}.  Starting? {1}", a, starting);
        if (!starting) {
            if (this.consistentHash instanceof UnionConsistentHash) {
                UnionConsistentHash uch = (UnionConsistentHash)this.consistentHash;
                this.consistentHash = uch.getNewConsistentHash();
                this.oldConsistentHash = null;
            }
            this.joiner = null;
        } else {
            this.topologyInfo.addNodeTopologyInfo(a, nodeTopologyInfo);
            this.log.trace((Object)"Node topology info added({0}).  Topology info is {1}", nodeTopologyInfo, this.topologyInfo);
            ConsistentHash chOld = this.consistentHash;
            if (chOld instanceof UnionConsistentHash) {
                throw new RuntimeException("Not expecting a union CH!");
            }
            this.oldConsistentHash = chOld;
            this.joiner = a;
            ConsistentHash chNew = ConsistentHashHelper.createConsistentHash(this.configuration, chOld.getCaches(), this.topologyInfo, a);
            this.consistentHash = new UnionConsistentHash(chOld, chNew);
        }
        this.log.trace((Object)"New CH is {0}", this.consistentHash);
        return this.topologyInfo.getNodeTopologyInfo(this.rpcManager.getAddress());
    }

    public void applyState(ConsistentHash consistentHash, Map<Object, InternalCacheValue> state) {
        this.log.trace("Apply state with " + state);
        for (Map.Entry<Object, InternalCacheValue> e : state.entrySet()) {
            if (!consistentHash.locate(e.getKey(), this.configuration.getNumOwners()).contains(this.self)) continue;
            InternalCacheValue v = e.getValue();
            PutKeyValueCommand put = this.cf.buildPutKeyValueCommand(e.getKey(), v.getValue(), v.getLifespan(), v.getMaxIdle());
            InvocationContext ctx = this.icc.createInvocationContext();
            ctx.setFlags(Flag.CACHE_MODE_LOCAL, Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_SHARED_CACHE_STORE);
            this.interceptorChain.invoke(ctx, put);
        }
    }

    @Override
    public CacheStore getCacheStoreForRehashing() {
        if (this.cacheLoaderManager == null || !this.cacheLoaderManager.isEnabled() || this.cacheLoaderManager.isShared()) {
            return null;
        }
        return this.cacheLoaderManager.getCacheStore();
    }

    @Override
    @ManagedAttribute(description="Checks whether the node is involved in a rehash.")
    @Metric(displayName="Is rehash in progress?", dataType=DataType.TRAIT)
    public boolean isRehashInProgress() {
        return !this.leavers.isEmpty() || this.rehashInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyReceivedState(Map<Object, InternalCacheValue> state) {
        this.applyState(this.consistentHash, state);
        boolean unlocked = false;
        try {
            this.drainLocalTransactionLog();
            unlocked = true;
        }
        finally {
            if (!unlocked) {
                this.transactionLogger.unlockAndDisable();
            }
        }
    }

    @Override
    public boolean isJoinComplete() {
        return this.joinComplete;
    }

    public void setJoinComplete(boolean joinComplete) {
        this.log.debug("Setting joinComplete to " + joinComplete + " for node " + this.rpcManager.getAddress());
        this.joinComplete = joinComplete;
    }

    void drainLocalTransactionLog() {
        List<WriteCommand> c;
        while (this.transactionLogger.shouldDrainWithoutLock()) {
            c = this.transactionLogger.drain();
            this.apply(c);
        }
        c = this.transactionLogger.drainAndLock();
        this.apply(c);
        this.transactionLogger.unlockAndDisable();
    }

    private void apply(List<WriteCommand> c) {
        for (WriteCommand cmd : c) {
            InvocationContext ctx = this.icc.createInvocationContext();
            ctx.setFlags(Flag.SKIP_REMOTE_LOOKUP);
            ctx.setFlags(Flag.CACHE_MODE_LOCAL);
            this.interceptorChain.invoke(ctx, cmd);
        }
    }

    @Override
    public List<Address> getAffectedNodes(Set<Object> affectedKeys) {
        if (affectedKeys == null || affectedKeys.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Address> an = new HashSet<Address>();
        for (List<Address> addresses : this.locateAll(affectedKeys).values()) {
            an.addAll(addresses);
        }
        return new ArrayList<Address>(an);
    }

    @Override
    public void applyRemoteTxLog(List<WriteCommand> txLogCommands) {
        this.apply(txLogCommands);
    }

    @ManagedOperation(description="Tells you whether a given key is local to this instance of the cache.  Only works with String keys.")
    @Operation(displayName="Is key local?")
    public boolean isLocatedLocally(@Parameter(name="key", description="Key to query") String key) {
        return this.isLocal(key);
    }

    @ManagedOperation(description="Locates an object in a cluster.  Only works with String keys.")
    @Operation(displayName="Locate key")
    public List<String> locateKey(@Parameter(name="key", description="Key to locate") String key) {
        LinkedList<String> l = new LinkedList<String>();
        for (Address a : this.locate(key)) {
            l.add(a.toString());
        }
        return l;
    }

    public String toString() {
        return "DistributionManagerImpl[rehashInProgress=" + this.rehashInProgress + ", consistentHash=" + this.consistentHash + "]";
    }

    public void setSelf(Address self) {
        this.self = self;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public TopologyInfo getTopologyInfo() {
        return this.topologyInfo;
    }

    @Listener
    public class ViewChangeListener {
        @ViewChanged
        public void handleViewChange(ViewChangedEvent e) {
            DistributionManagerImpl.this.log.trace("view change received. Needs to re-join? " + e.isNeedsToRejoin());
            if (e.isNeedsToRejoin()) {
                try {
                    DistributionManagerImpl.this.join();
                }
                catch (Exception e1) {
                    DistributionManagerImpl.this.log.fatal((Object)"Unable to recover from a partition merge!", e1);
                }
            } else {
                try {
                    boolean started = DistributionManagerImpl.this.startLatch.await(2L, TimeUnit.MINUTES);
                    if (started) {
                        DistributionManagerImpl.this.rehash(e.getNewMembers(), e.getOldMembers());
                    } else {
                        DistributionManagerImpl.this.log.warn("DistributionManager not started after waiting up to 2 minutes!  Not rehashing!");
                    }
                }
                catch (InterruptedException ie) {
                    DistributionManagerImpl.this.log.warn("View change interrupted; not rehashing!");
                }
            }
        }
    }
}

