/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jta.platform.internal;

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.jta.platform.internal.AbstractJtaPlatform;
import org.hibernate.service.jta.platform.spi.JtaPlatformException;

public class JBossStandAloneJtaPlatform
extends AbstractJtaPlatform {
    private static final String JBOSS_TM_CLASS_NAME = "com.arjuna.ats.jta.TransactionManager";
    private static final String JBOSS_UT_CLASS_NAME = "com.arjuna.ats.jta.UserTransaction";

    @Override
    protected TransactionManager locateTransactionManager() {
        try {
            Class jbossTmClass = this.serviceRegistry().getService(ClassLoaderService.class).classForName(JBOSS_TM_CLASS_NAME);
            return (TransactionManager)jbossTmClass.getMethod("transactionManager", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new JtaPlatformException("Could not obtain JBoss Transactions transaction manager instance", e);
        }
    }

    @Override
    protected UserTransaction locateUserTransaction() {
        try {
            Class jbossUtClass = this.serviceRegistry().getService(ClassLoaderService.class).classForName(JBOSS_UT_CLASS_NAME);
            return (UserTransaction)jbossUtClass.getMethod("userTransaction", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new JtaPlatformException("Could not obtain JBoss Transactions user transaction instance", e);
        }
    }
}

