/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.util.JavassistToReflect;

public class OptimizedFieldInvocations
extends OptimizedInvocations {
    protected static String getOptimizedInvocationClassName(CtClass clazz, CtField field, boolean get) throws Exception {
        StringBuffer sb = new StringBuffer(clazz.getName());
        sb.append(".").append(field.getName());
        if (get) {
            sb.append("_Get");
        } else {
            sb.append("_Set");
        }
        return sb.toString();
    }

    protected static void addCopy(ClassPool pool, CtClass invocation, boolean isStatic, boolean isGet) throws Exception {
        CtClass fieldInvocation = isGet ? pool.get("org.jboss.aop.joinpoint.FieldReadInvocation") : pool.get("org.jboss.aop.joinpoint.FieldWriteInvocation");
        CtMethod template = fieldInvocation.getDeclaredMethod("copy");
        String newExpr = isGet ? invocation.getName() + " wrapper = new " + invocation.getName() + "(this.field, this.index, this.interceptors); " : invocation.getName() + " wrapper = new " + invocation.getName() + "(this.field, this.index, this.value, this.interceptors); ";
        String code = "{    " + newExpr + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; " + "   wrapper.instanceResolver = this.instanceResolver; ";
        if (!isStatic) {
            code = code + "   wrapper.typedTargetObject = this.typedTargetObject; ";
            code = code + "   wrapper.targetObject = this.targetObject; ";
        }
        code = code + "   return wrapper; }";
        CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (String)code, (CtClass)invocation);
        copy.setModifiers(template.getModifiers());
        invocation.addMethod(copy);
    }

    protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtField field, boolean get) throws Exception {
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass fieldInvocation = get ? pool.get("org.jboss.aop.joinpoint.FieldReadInvocation") : pool.get("org.jboss.aop.joinpoint.FieldWriteInvocation");
        String className = OptimizedFieldInvocations.getOptimizedInvocationClassName(clazz, field, get);
        boolean makeInnerClass = true;
        try {
            CtClass existing = pool.get(className);
            if (existing.isFrozen()) {
                existing.defrost();
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        CtClass invocation = OptimizedFieldInvocations.makeInvocationClass(pool, makeInnerClass, clazz, className, fieldInvocation);
        invocation.stopPruning(true);
        boolean isStatic = Modifier.isStatic((int)field.getModifiers());
        if (!isStatic) {
            CtField target = new CtField(field.getDeclaringClass(), "typedTargetObject", invocation);
            target.setModifiers(1);
            invocation.addField(target);
        }
        OptimizedFieldInvocations.addCopy((ClassPool)pool, invocation, isStatic, get);
        OptimizedFieldInvocations.setInvocationInvokeCode(invocation, field, get);
        TransformerCommon.compileOrLoadClass(field.getDeclaringClass(), invocation);
        return invocation.getName();
    }

    private static void setInvocationInvokeCode(CtClass invocation, CtField field, boolean get) throws CannotCompileException, NotFoundException {
        String ref;
        CtMethod in = invocation.getSuperclass().getDeclaredMethod("invokeTarget");
        String code = "{";
        String string = ref = Modifier.isStatic((int)field.getModifiers()) ? field.getDeclaringClass().getName() + "." : " typedTargetObject.";
        if (get) {
            code = code + "return ($w) " + ref + field.getName() + ";";
        } else {
            CtClass type = field.getType();
            code = code + ref + field.getName() + " = " + JavassistToReflect.castInvocationValueToTypeString(type) + " return null;";
        }
        code = code + "}";
        CtMethod invokeTarget = CtNewMethod.make((CtClass)in.getReturnType(), (String)in.getName(), (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), (String)code, (CtClass)invocation);
        invokeTarget.setModifiers(in.getModifiers());
        invocation.addMethod(invokeTarget);
    }
}

