/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.instrument.WrapperTransformer;
import org.jboss.aop.util.JavassistMethodHashing;

public abstract class MethodExecutionTransformer {
    public static final String METHOD_INFO_CLASS_NAME = "org.jboss.aop.MethodInfo";
    private static final WrapperTransformer wrapper = new WrapperTransformer(WrapperTransformer.SINGLE_TRANSFORMATION);
    protected Instrumentor instrumentor;
    private JoinpointClassifier classifier;

    protected MethodExecutionTransformer(Instrumentor instrumentor) {
        this.instrumentor = instrumentor;
        this.classifier = instrumentor.joinpointClassifier;
    }

    protected static WrapperTransformer getWrapper() {
        return wrapper;
    }

    protected JoinpointClassifier getClassifier() {
        return this.classifier;
    }

    protected String addMethodInfoField(int modifiers, CtClass addTo, MethodTransformation trans) throws NotFoundException, CannotCompileException {
        return this.addMethodInfoField(modifiers, addTo, trans, null);
    }

    protected String addMethodInfoField(int modifiers, CtClass addTo, MethodTransformation trans, CtField.Initializer init) throws NotFoundException, CannotCompileException {
        String name = MethodExecutionTransformer.getMethodInfoFieldName(trans.getOriginalName(), trans.getHash());
        TransformerCommon.addInfoField(this.instrumentor, METHOD_INFO_CLASS_NAME, name, modifiers, addTo, this.addInfoAsWeakReference(), init);
        return name;
    }

    protected boolean addInfoAsWeakReference() {
        return true;
    }

    public static String getMethodNameHash(String methodName, long methodHash) {
        String hash = methodHash < 0L ? "_N_" + -1L * methodHash : "" + methodHash;
        return methodName + hash;
    }

    public static String getMethodInfoFieldName(String methodName, long methodHash) {
        String name = "aop$MethodInfo_" + MethodExecutionTransformer.getMethodNameHash(methodName, methodHash);
        return name;
    }

    protected static String methodInfoFromWeakReference(String localName, String methodInfoName) {
        return TransformerCommon.infoFromWeakReference(METHOD_INFO_CLASS_NAME, localName, methodInfoName);
    }

    protected JoinpointClassification[] classifyMethods(CtClass clazz, ClassAdvisor advisor) throws NotFoundException {
        CtMethod[] methods = clazz.getDeclaredMethods();
        JoinpointClassification[] classification = new JoinpointClassification[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            classification[i] = this.classifier.classifyMethodExecution(methods[i], advisor);
        }
        return classification;
    }

    public void instrument(CtClass clazz, ClassAdvisor advisor) throws NotFoundException, CannotCompileException {
        JoinpointClassification[] classification = this.classifyMethods(clazz, advisor);
        CtMethod[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (classification[i] == JoinpointClassification.NOT_INSTRUMENTED) continue;
            this.instrumentor.setupBasics(clazz);
            MethodTransformation trans = new MethodTransformation(this.instrumentor, clazz, methods[i]);
            boolean wrap = classification[i].equals(JoinpointClassification.WRAPPED);
            this.transformMethod(trans, wrap);
            int modifier = trans.getWMethod().getModifiers();
            if (!Modifier.isNative((int)modifier)) continue;
            trans.getWMethod().setModifiers(modifier &= 0xFFFFFEFF);
        }
    }

    public void wrap(CtClass clazz, Collection methodInfos) throws Exception {
        for (MethodInfo methodInfo : methodInfos) {
            Method method = methodInfo.getAdvisedMethod();
            AOPClassPool classPool = (AOPClassPool)clazz.getClassPool();
            Class<?>[] parameterTypes = method.getParameterTypes();
            CtClass[] javassistParameterTypes = new CtClass[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                classPool.getLocally(parameterTypes[i].getName());
            }
            if (method.getName().indexOf("access$") >= 0) continue;
            String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
            CtMethod wmethod = clazz.getDeclaredMethod(method.getName(), javassistParameterTypes);
            if (wrapper.isNotPrepared((CtMember)wmethod, 0)) continue;
            MethodTransformation trans = new MethodTransformation(this.instrumentor, clazz, clazz.getDeclaredMethod(wrappedName, javassistParameterTypes), method.getName(), clazz.getDeclaredMethod(method.getName(), javassistParameterTypes), wrappedName);
            wrapper.wrap((CtMember)trans.getWMethod(), 0);
            String methodInfoFieldName = MethodExecutionTransformer.getMethodInfoFieldName(trans.getOriginalName(), trans.getHash());
            this.doWrap(trans, methodInfoFieldName);
        }
    }

    public void unwrap(CtClass clazz, Collection methodInfos) throws Exception {
        for (MethodInfo methodInfo : methodInfos) {
            Method method = methodInfo.getAdvisedMethod();
            AOPClassPool classPool = (AOPClassPool)clazz.getClassPool();
            Class<?>[] parameterTypes = method.getParameterTypes();
            CtClass[] javassistParameterTypes = new CtClass[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                classPool.getLocally(parameterTypes[i].getName());
            }
            CtMethod javassistWMethod = clazz.getDeclaredMethod(method.getName(), javassistParameterTypes);
            if (wrapper.isNotPrepared((CtMember)javassistWMethod, 0)) continue;
            CtMethod javassistMethod = clazz.getDeclaredMethod(ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName()), javassistParameterTypes);
            wrapper.unwrap((CtMember)javassistWMethod, 0);
            javassistWMethod.setBody(javassistMethod, null);
        }
    }

    protected void copyAnnotations(CtMethod src, CtMethod dest) {
        AnnotationsAttribute visible;
        javassist.bytecode.MethodInfo mi = src.getMethodInfo2();
        javassist.bytecode.MethodInfo wmi = dest.getMethodInfo2();
        AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
        if (invisible != null) {
            wmi.addAttribute(invisible.copy(wmi.getConstPool(), new HashMap()));
        }
        if ((visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations")) != null) {
            wmi.addAttribute(visible.copy(wmi.getConstPool(), new HashMap()));
        }
    }

    protected static String getAopReturnStr(CtMethod method) throws NotFoundException {
        return MethodExecutionTransformer.getAopReturnStr(method.getReturnType().equals(CtClass.voidType));
    }

    protected static String getAopReturnStr(boolean isVoid) throws NotFoundException {
        return isVoid ? "" : "return ($r)";
    }

    protected static String getReturnStr(CtMethod method) throws NotFoundException {
        return MethodExecutionTransformer.getReturnStr(method.getReturnType().equals(CtClass.voidType));
    }

    protected static String getReturnStr(boolean isVoid) throws NotFoundException {
        return isVoid ? "" : "return ";
    }

    protected abstract void transformMethod(MethodTransformation var1, boolean var2) throws CannotCompileException, NotFoundException;

    protected abstract void doWrap(MethodTransformation var1, String var2) throws NotFoundException, Exception;

    protected class MethodTransformation {
        Instrumentor instrumentor;
        CtClass clazz;
        CtMethod method;
        String originalName;
        CtMethod wmethod;
        String wrappedName;
        long hash;

        public MethodTransformation(Instrumentor instrumentor, CtClass clazz, CtMethod method) {
            this.instrumentor = instrumentor;
            this.clazz = clazz;
            this.method = method;
            this.originalName = method.getName();
            this.hash = JavassistMethodHashing.methodHash(method);
        }

        public MethodTransformation(Instrumentor instrumentor, CtClass clazz, CtMethod method, String originalName, CtMethod wmethod, String wrappedName) {
            this.instrumentor = instrumentor;
            this.clazz = clazz;
            this.method = method;
            this.originalName = originalName;
            this.wmethod = wmethod;
            this.wrappedName = wrappedName;
            this.hash = JavassistMethodHashing.methodHash(wmethod);
        }

        public MethodTransformation(Instrumentor instrumentor, CtClass clazz, CtMethod method, String originalName, CtMethod wmethod, String wrappedName, long hash) {
            this.instrumentor = instrumentor;
            this.clazz = clazz;
            this.method = method;
            this.originalName = originalName;
            this.wmethod = wmethod;
            this.wrappedName = wrappedName;
            this.hash = hash;
        }

        public void setWMethod(CtMethod wmethod, String wrappedName) {
            this.wmethod = wmethod;
            this.wrappedName = wrappedName;
        }

        public void setWMethodBody(String code) throws CannotCompileException {
            this.wmethod.setBody(code);
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public String getWrappedName() {
            return this.wrappedName;
        }

        public CtClass getClazz() {
            return this.clazz;
        }

        public String getClazzName() {
            return this.clazz.getName();
        }

        public CtMethod getMethod() {
            return this.method;
        }

        public CtMethod getWMethod() {
            return this.wmethod;
        }

        public long getHash() {
            return this.hash;
        }

        public Instrumentor getInstrumentor() {
            return this.instrumentor;
        }
    }
}

