/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.CodeConversionObserver;
import org.jboss.aop.instrument.Codifier;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.instrument.WrapperTransformer;
import org.jboss.aop.pointcut.Pointcut;

public abstract class ConstructorExecutionTransformer
implements CodeConversionObserver {
    protected static final String CONSTRUCTOR_INFO_CLASS_NAME = "org.jboss.aop.ConstructorInfo";
    protected Instrumentor instrumentor;
    protected Codifier codifier;
    private JoinpointClassifier classifier;
    private static final WrapperTransformer wrapper = new WrapperTransformer(new String[]{"wrapperStatus", "constructorsWrapped"});
    protected static final int CONSTRUCTOR_STATUS = 0;
    private static final int ALL_CONSTRUCTORS_STATUS = 1;

    protected ConstructorExecutionTransformer(Instrumentor instrumentor) {
        this.instrumentor = instrumentor;
        this.codifier = new Codifier();
        this.classifier = instrumentor.joinpointClassifier;
    }

    protected Instrumentor getInstrumentor() {
        return this.instrumentor;
    }

    protected WrapperTransformer getWrapper() {
        return wrapper;
    }

    public static String constructorFactory(String className) {
        if (className.indexOf(46) >= 0) {
            throw new RuntimeException("constructorFactory() takes a simple class name: " + className);
        }
        return className + "_new_" + "$aop";
    }

    protected String addConstructorInfoField(int modifiers, CtClass addTo, String infoName) throws NotFoundException, CannotCompileException {
        return this.addConstructorInfoField(modifiers, addTo, infoName, null);
    }

    protected String addConstructorInfoField(int modifiers, CtClass addTo, String infoName, CtField.Initializer init) throws NotFoundException, CannotCompileException {
        if (this.instrumentor.getClassPool() != null) {
            try {
                addTo.getDeclaredField(infoName);
                return infoName;
            }
            catch (NotFoundException e) {
                TransformerCommon.addInfoField(this.instrumentor, CONSTRUCTOR_INFO_CLASS_NAME, infoName, modifiers, addTo, this.addInfoAsWeakReference(), init);
            }
        }
        return infoName;
    }

    protected boolean addInfoAsWeakReference() {
        return true;
    }

    public static String getConstructorInfoFieldName(String classname, int index) {
        if (classname.indexOf(46) >= 0) {
            throw new RuntimeException("Simple name should be used: " + classname);
        }
        return "aop$constructorInfo_" + index;
    }

    protected static String constructorInfoFromWeakReference(String localName, String ctorInfoName) {
        return TransformerCommon.infoFromWeakReference(CONSTRUCTOR_INFO_CLASS_NAME, localName, ctorInfoName);
    }

    public boolean transform(CtClass clazz, ClassAdvisor classAdvisor) throws Exception {
        List constructors = this.instrumentor.getConstructors(clazz);
        JoinpointClassification[] classification = this.classifyConstructor(constructors, classAdvisor);
        boolean wrappersGenerated = false;
        boolean oneOrMoreWrapped = false;
        int i = 0;
        boolean dynamicallyWrapped = false;
        boolean notDynamicallyWrapped = false;
        CtConstructor firstConstructor = null;
        if (!constructors.isEmpty()) {
            firstConstructor = (CtConstructor)constructors.get(0);
        }
        for (CtConstructor constructor : constructors) {
            if (classification[i] != JoinpointClassification.NOT_INSTRUMENTED || oneOrMoreWrapped) {
                if (!wrappersGenerated) {
                    this.buildConstructorWrappers(clazz, classAdvisor);
                    wrappersGenerated = true;
                    wrapper.prepareForWrapping((CtMember)firstConstructor, 1);
                }
                if (classification[i].equals(JoinpointClassification.WRAPPED)) {
                    if (!oneOrMoreWrapped) {
                        for (int j = 0; j < i; ++j) {
                            this.setEmptyWrapperCodeLater((CtConstructor)constructors.get(j));
                        }
                        oneOrMoreWrapped = true;
                    }
                    this.wrap(clazz, constructor, i);
                    dynamicallyWrapped = dynamicallyWrapped || classification[i].equals(JoinpointClassification.DYNAMICALY_WRAPPED);
                    notDynamicallyWrapped = notDynamicallyWrapped || !classification[i].equals(JoinpointClassification.DYNAMICALY_WRAPPED);
                } else if (oneOrMoreWrapped) {
                    this.setEmptyWrapperCodeLater(constructor);
                }
            }
            ++i;
        }
        if (oneOrMoreWrapped) {
            this.wrapAllConstructors(clazz, firstConstructor, null);
        }
        if (dynamicallyWrapped && !notDynamicallyWrapped) {
            this.instrumentor.dynamicTransformationObserver.constructorDynamicalyWrapped();
        }
        return wrappersGenerated;
    }

    private void wrapAllConstructors(CtClass clazz, CtConstructor firstConstructor, List constructors) throws NotFoundException, CannotCompileException {
        wrapper.wrap((CtMember)firstConstructor, 1);
        if (constructors == null) {
            return;
        }
        for (CtConstructor constructor : constructors) {
            if (wrapper.isWrapped((CtMember)constructor, 0)) continue;
            this.setEmptyWrapperCodeLater(constructor);
        }
        this.instrumentor.converter.replaceNew(clazz, clazz, ConstructorExecutionTransformer.constructorFactory(clazz.getSimpleName()));
    }

    public void wrap(CtClass clazz, Collection constructorIndexes) throws Exception {
        List constructors = this.instrumentor.getConstructors(clazz);
        CtConstructor firstConstructor = (CtConstructor)constructors.get(0);
        if (wrapper.isNotPrepared((CtMember)firstConstructor, 1)) {
            return;
        }
        Iterator iterator = constructorIndexes.iterator();
        while (iterator.hasNext()) {
            int constructorIndex = (Integer)iterator.next();
            CtConstructor constructor = (CtConstructor)constructors.get(constructorIndex);
            this.wrap(clazz, constructor, constructorIndex);
        }
        if (!wrapper.isWrapped((CtMember)firstConstructor, 1)) {
            this.wrapAllConstructors(clazz, firstConstructor, constructors);
        }
    }

    private void wrap(CtClass clazz, CtConstructor constructor, int constructorIndex) throws NotFoundException, Exception, CannotCompileException {
        if (wrapper.isNotPrepared((CtMember)constructor, 0)) {
            return;
        }
        wrapper.wrap((CtMember)constructor, 0);
        CtMethod wrapperMethod = clazz.getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(clazz.getSimpleName()), constructor.getParameterTypes());
        this.setTemporaryWrapperCode(constructor.getDeclaringClass(), wrapperMethod);
        ConstructorTransformation trans = new ConstructorTransformation(clazz, constructor, wrapperMethod, constructorIndex);
        this.createWrapper(trans);
    }

    public void unwrap(CtClass clazz, Collection constructorIndexes) throws NotFoundException {
        List constructors = this.instrumentor.getConstructors(clazz);
        if (wrapper.isNotPrepared((CtMember)constructors.get(0), 1)) {
            return;
        }
        Iterator iterator = constructorIndexes.iterator();
        while (iterator.hasNext()) {
            int constructorIndex = (Integer)iterator.next();
            CtConstructor constructor = (CtConstructor)constructors.get(constructorIndex);
            if (wrapper.isNotPrepared((CtMember)constructor, 0)) continue;
            wrapper.unwrap((CtMember)constructor, 0);
            this.setEmptyWrapperCode(constructor);
        }
    }

    public void codeConverted() throws CannotCompileException {
        this.codifier.codifyPending();
    }

    public boolean replaceConstructorAccess(ClassAdvisor sourceAdvisor, CtClass source) throws NotFoundException {
        if (!this.isAnyConstructorAdvised(source, sourceAdvisor)) {
            return false;
        }
        this.instrumentor.converter.replaceNew(source, source, ConstructorExecutionTransformer.constructorFactory(source.getSimpleName()));
        return true;
    }

    protected void buildConstructorWrappers(CtClass clazz, ClassAdvisor advisor) throws Exception {
        this.instrumentor.setupBasics(clazz);
        List constructors = this.instrumentor.getConstructors(clazz);
        Iterator it = constructors.iterator();
        int index = 0;
        while (it.hasNext()) {
            CtConstructor constructor = (CtConstructor)it.next();
            int mod = 8;
            mod = (constructor.getModifiers() & 1) != 0 ? (mod |= 1) : ((constructor.getModifiers() & 4) != 0 ? (mod |= 4) : ((constructor.getModifiers() & 2) != 0 ? (mod |= 2) : (mod |= 1)));
            this.initialiseWrapper(mod, constructor, index);
            this.generateConstructorInfoField(clazz, constructor, index);
            ++index;
        }
    }

    protected void generateConstructorInfoField(CtClass clazz, CtConstructor constructor, int index) throws CannotCompileException, NotFoundException {
        String name = ConstructorExecutionTransformer.getConstructorInfoFieldName(clazz.getSimpleName(), index);
        this.addConstructorInfoField(10, clazz, name);
    }

    protected void setTemporaryWrapperCode(CtClass type, CtMethod wrapperMethod) {
        String code = "{   return null;}";
        try {
            wrapperMethod.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw new RuntimeException(e);
        }
    }

    protected void setEmptyWrapperCode(CtConstructor constructor) throws NotFoundException {
        CtMethod wrapperMethod = this.getWrapperMethod(constructor);
        String code = "{     return new " + constructor.getDeclaringClass().getName() + "($$); " + "}";
        try {
            wrapperMethod.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw new RuntimeException(e);
        }
    }

    protected void setEmptyWrapperCodeLater(CtConstructor constructor) throws NotFoundException {
        CtMethod wrapperMethod = this.getWrapperMethod(constructor);
        String code = "{     return new " + constructor.getDeclaringClass().getName() + "($$); " + "}";
        this.codifier.addPendingCode(wrapperMethod, code);
    }

    protected boolean isAnyConstructorAdvised(CtClass clazz, ClassAdvisor advisor) throws NotFoundException {
        CtConstructor[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            JoinpointClassification classification = this.classifier.classifyConstructorExecution(constructors[i], advisor);
            if (!classification.equals(JoinpointClassification.WRAPPED)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdvisableConstructor(CtConstructor con, ClassAdvisor advisor) throws NotFoundException {
        for (Pointcut pointcut : advisor.getManager().getPointcuts().values()) {
            if (!pointcut.matchesExecution((Advisor)advisor, con)) continue;
            return true;
        }
        return false;
    }

    protected JoinpointClassification[] classifyConstructor(List constructors, ClassAdvisor advisor) throws NotFoundException {
        JoinpointClassification[] classification = new JoinpointClassification[constructors.size()];
        int index = 0;
        for (CtConstructor constructor : constructors) {
            classification[index] = this.classifier.classifyConstructorExecution(constructor, advisor);
            ++index;
        }
        return classification;
    }

    protected abstract void createWrapper(ConstructorTransformation var1) throws CannotCompileException, NotFoundException;

    protected void initialiseWrapper(int mod, CtConstructor constructor, int index) throws NotFoundException, CannotCompileException {
        CtClass clazz = constructor.getDeclaringClass();
        CtClass[] exceptions = constructor.getExceptionTypes();
        String name = clazz.getSimpleName();
        CtClass type = constructor.getDeclaringClass();
        CtMethod wmethod = CtNewMethod.make((CtClass)type, (String)ConstructorExecutionTransformer.constructorFactory(name), (CtClass[])constructor.getParameterTypes(), (CtClass[])exceptions, null, (CtClass)clazz);
        wmethod.setModifiers(mod);
        this.setTemporaryWrapperCode(type, wmethod);
        clazz.addMethod(wmethod);
        this.getWrapper().prepareForWrapping((CtMember)constructor, 0);
    }

    protected CtMethod getWrapperMethod(CtConstructor constructor) throws NotFoundException {
        CtClass clazz = constructor.getDeclaringClass();
        return clazz.getDeclaredMethod(ConstructorExecutionTransformer.constructorFactory(clazz.getSimpleName()), constructor.getParameterTypes());
    }

    protected class ConstructorTransformation {
        CtClass clazz;
        CtConstructor constructor;
        CtMethod wrapperMethod;
        int index;

        public ConstructorTransformation(CtClass clazz, CtConstructor constructor, CtMethod wrapper, int index) {
            this.clazz = clazz;
            this.constructor = constructor;
            this.wrapperMethod = wrapper;
            this.index = index;
        }

        public CtMethod getWrapperMethod() {
            return this.wrapperMethod;
        }

        public void setWrapperMethod(CtMethod wrapperMethod) {
            this.wrapperMethod = wrapperMethod;
        }

        public CtClass getClazz() {
            return this.clazz;
        }

        public CtConstructor getConstructor() {
            return this.constructor;
        }

        public int getIndex() {
            return this.index;
        }

        public String getClassName() {
            return this.clazz.getName();
        }

        public String getSimpleName() {
            return this.clazz.getSimpleName();
        }
    }
}

