/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Constructor;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.ConByConInfo;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.CallerTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
import org.jboss.aop.util.ReflectToJavassist;

public class ConByConJoinPointGenerator
extends JoinPointGenerator {
    public static final String GENERATOR_PREFIX = "generator_CByC_";
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_CByC_";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_CByC_";
    private static final Class INVOCATION_TYPE = ConstructorCalledByConstructorInvocation.class;
    private static final CtClass INVOCATION_CT_TYPE;

    public ConByConJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info) {
        super(advisor, info);
    }

    protected void initialiseJoinPointNames() {
        this.joinpointClassName = ConByConJoinPointGenerator.getInfoClassName(this.callingIndex(), this.calledClass(), this.calledConHash());
        this.joinpointFieldName = ConByConJoinPointGenerator.getInfoFieldName(this.callingIndex(), this.calledClass(), this.calledConHash());
    }

    private int callingIndex() {
        return ((ConByConInfo)this.info).getCallingIndex();
    }

    private String calledClass() {
        return ((ConByConInfo)this.info).getCalledClass().getName();
    }

    private long calledConHash() {
        return ((ConByConInfo)this.info).getCalledConHash();
    }

    protected boolean isVoid() {
        return false;
    }

    protected Class getReturnType() {
        return ((ConByConInfo)this.info).getCalledClass();
    }

    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointGenerator.AdviceSetup setup) {
        Constructor ctor = ((ConByConInfo)this.info).getConstructor();
        return new AdviceMethodProperties(setup.getAspectClass(), setup.getAdviceName(), this.info.getClass(), INVOCATION_TYPE, ctor.getDeclaringClass(), ctor.getParameterTypes(), ctor.getExceptionTypes());
    }

    protected boolean isCaller() {
        return true;
    }

    protected boolean hasCallingObject() {
        return false;
    }

    protected boolean hasTargetObject() {
        return false;
    }

    protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, JoinPointInfo newInfo) throws CannotCompileException, NotFoundException {
        super.overrideDispatchMethods(superClass, clazz, (ConByConInfo)newInfo);
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, int callingIndex, CtClass callingClass, CtConstructor targetCtor, String classname, long calledHash, String ciname) throws NotFoundException, CannotCompileException {
        instrumentor.addJoinPointGeneratorFieldToGenAdvisor(ConByConJoinPointGenerator.getJoinPointGeneratorFieldName(callingIndex, classname, calledHash));
        BaseClassGenerator generator = new BaseClassGenerator(instrumentor, callingClass, callingIndex, classname, targetCtor, calledHash, ciname);
        return generator.generate();
    }

    protected String getJoinPointGeneratorFieldName() {
        return ConByConJoinPointGenerator.getJoinPointGeneratorFieldName(this.callingIndex(), this.calledClass(), this.calledConHash());
    }

    protected static String getInfoClassName(int callingIndex, String classname, long calledHash) {
        return JOINPOINT_CLASS_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
    }

    protected static String getInfoFieldName(int callingIndex, String classname, long calledHash) {
        return JOINPOINT_FIELD_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
    }

    protected static String getJoinPointGeneratorFieldName(int callingIndex, String classname, long calledHash) {
        return GENERATOR_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass callingClass;
        int callingIndex;
        String classname;
        CtClass targetClass;
        CtConstructor targetCtor;
        long calledHash;
        String ciname;
        CtClass jp;
        CtMethod invokeJoinpointMethod;
        CtConstructor publicConstructor;
        CtConstructor protectedConstructor;
        CtClass[] params;
        CtClass constructorInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass callingClass, int callingIndex, String classname, CtConstructor targetCtor, long calledHash, String ciname) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.callingClass = callingClass;
            this.callingIndex = callingIndex;
            this.classname = classname;
            this.targetClass = instrumentor.forName(classname);
            this.targetCtor = targetCtor;
            this.calledHash = calledHash;
            this.ciname = ciname;
            this.params = targetCtor.getParameterTypes();
            this.constructorInfoClass = instrumentor.forName(CallerTransformer.CON_BY_CON_INFO_CLASS_NAME);
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            this.addArgumentsFieldsAndAccessors();
            this.addInvokeJoinpointMethod();
            this.addMethodInfoField();
            this.addPublicConstructor();
            this.addProtectedConstructor();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.callingClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = ConByConJoinPointGenerator.getInfoClassName(this.callingIndex, this.targetClass.getName(), this.calledHash);
            this.jp = TransformerCommon.makeNestedClass(this.callingClass, className, true, 9, INVOCATION_CT_TYPE);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addArgumentsFieldsAndAccessors() throws NotFoundException, CannotCompileException {
            OptimizedBehaviourInvocations.addArgumentFieldsToInvocation(this.jp, this.params);
            OptimizedBehaviourInvocations.addSetArguments(this.instrumentor.getClassPool(), this.jp, this.params);
            OptimizedBehaviourInvocations.addGetArguments(this.instrumentor.getClassPool(), this.jp, this.params);
        }

        private void addPublicConstructor() throws CannotCompileException {
            this.publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.constructorInfoClass}, (CtClass[])new CtClass[0], (String)"{super($1, $1.getInterceptors()); this.info = $1;}", (CtClass)this.jp);
            this.jp.addConstructor(this.publicConstructor);
        }

        protected void addProtectedConstructor() throws CannotCompileException {
            int offset;
            CtClass[] ctorParams = new CtClass[this.params.length + 1];
            ctorParams[0] = this.jp;
            System.arraycopy(this.params, 0, ctorParams, 1, this.params.length);
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            for (int i = offset = 1; i < ctorParams.length; ++i) {
                body.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            body.append("}");
            this.protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams, (CtClass[])new CtClass[0], (String)body.toString(), (CtClass)this.jp);
            this.protectedConstructor.setModifiers(4);
            this.jp.addConstructor(this.protectedConstructor);
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            this.invokeJoinpointMethod = CtNewMethod.make((CtClass)this.targetClass, (String)"invokeJoinpoint", (CtClass[])this.params, (CtClass[])this.targetCtor.getExceptionTypes(), null, (CtClass)this.jp);
            this.invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(this.invokeJoinpointMethod);
            return this.invokeJoinpointMethod;
        }

        private void addMethodInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.constructorInfoClass, "info", this.jp);
            infoField.setModifiers(4);
            this.jp.addField(infoField);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            this.addInvokeNextDispatchMethod();
            if (this.params.length > 0) {
                this.addInvokeJoinpointDispatchMethod();
            }
            this.addInvokeTargetMethod();
        }

        private void addInvokeNextDispatchMethod() throws CannotCompileException, NotFoundException {
            StringBuffer parameters = new StringBuffer("(");
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("arg" + i);
            }
            parameters.append(")");
            String body = "{   " + this.targetClass.getName() + " obj = new " + this.targetClass.getName() + parameters + ";" + "   setTargetObject(obj);" + "   return obj;" + "}";
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)this.targetClass, (String)"dispatch", (CtClass[])new CtClass[0], (CtClass[])this.targetCtor.getExceptionTypes(), (String)body, (CtClass)this.jp);
                dispatch.setModifiers(4);
                this.jp.addMethod(dispatch);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", this.params), e);
            }
        }

        private void addInvokeJoinpointDispatchMethod() throws CannotCompileException, NotFoundException {
            String body = "{   " + this.targetClass.getName() + " obj = new " + this.targetClass.getName() + "($$);" + "   setTargetObject(obj);" + "   return obj;" + "}";
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)this.targetClass, (String)"dispatch", (CtClass[])this.params, (CtClass[])this.targetCtor.getExceptionTypes(), (String)body, (CtClass)this.jp);
                dispatch.setModifiers(4);
                this.jp.addMethod(dispatch);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for dispatch method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", this.params), e);
            }
        }

        private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException {
            CtMethod template = INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
            String body = "{return dispatch();}";
            CtMethod invokeTarget = CtNewMethod.make((CtClass)template.getReturnType(), (String)template.getName(), (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (String)body, (CtClass)this.jp);
            this.jp.addMethod(invokeTarget);
        }
    }
}

