/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.OptimizedMethodInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;

public class PerVmAdvice {
    private static long counter = 0L;

    public static synchronized Interceptor generateOptimized(Joinpoint joinpoint, AspectManager manager, String adviceName, AspectDefinition a) throws Exception {
        Object aspect = manager.getPerVMAspect(a);
        return PerVmAdvice.generateInterceptor(joinpoint, aspect, adviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interceptor generateInterceptor(Joinpoint joinpoint, Object aspect, String adviceName) throws Exception {
        ClassLoader cl = aspect.getClass().getClassLoader();
        String name = "org.jboss.aop.advice." + aspect.getClass().getName() + "_z_" + adviceName + "_" + System.identityHashCode(cl);
        Class iclass = null;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        Class<PerVmAdvice> clazz = PerVmAdvice.class;
        synchronized (PerVmAdvice.class) {
            ClassPool pool;
            try {
                iclass = cl.loadClass(name);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                pool = AspectManager.instance().findClassPool(cl);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
            if (iclass == null) {
                try {
                    ClassLoader pcl = pool.getClassLoader();
                    iclass = pcl.loadClass(name);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (iclass == null) {
                Method[] methods = aspect.getClass().getMethods();
                ArrayList<Method> matches = new ArrayList<Method>();
                for (int i = 0; i < methods.length; ++i) {
                    if (!methods[i].getName().equals(adviceName)) continue;
                    matches.add(methods[i]);
                }
                if (matches.size() == 1) {
                    Method method = (Method)matches.get(0);
                    if (joinpoint instanceof MethodJoinpoint && (method.getParameterTypes().length == 0 || method.getParameterTypes().length > 1 || !Invocation.class.isAssignableFrom(method.getParameterTypes()[0]))) {
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return PerVmAdvice.generateArgsInterceptor(aspect, method, joinpoint);
                    }
                }
                CtClass clazz2 = TransformerCommon.makeClass(pool, name);
                CtClass interceptorInterface = pool.get("org.jboss.aop.advice.Interceptor");
                CtClass abstractAdviceClass = pool.get("org.jboss.aop.advice.AbstractAdvice");
                clazz2.setSuperclass(abstractAdviceClass);
                CtClass aspectClass = pool.get(aspect.getClass().getName());
                CtField field = new CtField(aspectClass, "aspectField", clazz2);
                field.setModifiers(1);
                clazz2.addField(field);
                CtMethod getNameTemplate = interceptorInterface.getDeclaredMethod("getName");
                String getNameBody = "{    return \"" + aspect.getClass().getName() + "." + adviceName + "\"; " + "}";
                CtMethod getName = CtNewMethod.make((CtClass)getNameTemplate.getReturnType(), (String)"getName", (CtClass[])getNameTemplate.getParameterTypes(), (CtClass[])getNameTemplate.getExceptionTypes(), (String)getNameBody, (CtClass)clazz2);
                getName.setModifiers(1);
                clazz2.addMethod(getName);
                CtMethod invokeTemplate = interceptorInterface.getDeclaredMethod("invoke");
                StringBuffer invokeBody = new StringBuffer();
                invokeBody.append("{  ");
                if (matches.size() > 1) {
                    for (int i = 0; i < matches.size(); ++i) {
                        Method advice = (Method)matches.get(i);
                        String param = advice.getParameterTypes()[0].getName();
                        invokeBody.append("   if ($1 instanceof " + param + ") return aspectField." + adviceName + "((" + param + ")$1); ");
                    }
                    invokeBody.append("   return (org.jboss.aop.joinpoint.Invocation)null; ");
                } else {
                    Method advice = (Method)matches.get(0);
                    String param = advice.getParameterTypes()[0].getName();
                    invokeBody.append("return aspectField." + adviceName + "((" + param + ")$1); ");
                }
                invokeBody.append("}");
                CtMethod invoke = CtNewMethod.make((CtClass)invokeTemplate.getReturnType(), (String)"invoke", (CtClass[])invokeTemplate.getParameterTypes(), (CtClass[])invokeTemplate.getExceptionTypes(), (String)invokeBody.toString(), (CtClass)clazz2);
                invoke.setModifiers(1);
                clazz2.addMethod(invoke);
                iclass = TransformerCommon.toClass(clazz2, cl);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            Interceptor rtn = (Interceptor)iclass.newInstance();
            Field f = iclass.getField("aspectField");
            f.set(rtn, aspect);
            return rtn;
        }
    }

    public static Interceptor generateArgsInterceptor(Object aspect, Method advice, Joinpoint joinpoint) throws Exception {
        Method method = ((MethodJoinpoint)joinpoint).getMethod();
        String optimized = OptimizedMethodInvocations.getOptimizedInvocationClassName(method);
        ClassPool pool = AspectManager.instance().findClassPool(aspect.getClass().getClassLoader());
        CtClass clazz = TransformerCommon.makeClass(pool, "org.jboss.aop.advice." + aspect.getClass().getName() + counter++);
        CtClass interceptorInterface = pool.get("org.jboss.aop.advice.Interceptor");
        clazz.addInterface(interceptorInterface);
        CtClass aspectClass = pool.get(aspect.getClass().getName());
        CtField field = new CtField(aspectClass, "aspectField", clazz);
        field.setModifiers(1);
        clazz.addField(field);
        CtMethod getNameTemplate = interceptorInterface.getDeclaredMethod("getName");
        String getNameBody = "{    return \"" + aspect.getClass().getName() + "." + advice.getName() + "\"; " + "}";
        CtMethod getName = CtNewMethod.make((CtClass)getNameTemplate.getReturnType(), (String)"getName", (CtClass[])getNameTemplate.getParameterTypes(), (CtClass[])getNameTemplate.getExceptionTypes(), (String)getNameBody, (CtClass)clazz);
        getName.setModifiers(1);
        clazz.addMethod(getName);
        String invokeBody = null;
        invokeBody = Invocation.class.isAssignableFrom(advice.getParameterTypes()[0]) ? PerVmAdvice.getInvocationBody(optimized, advice, method) : PerVmAdvice.getThreadStackBody(optimized, advice, method);
        CtMethod invoke = CtNewMethod.make((String)invokeBody, (CtClass)clazz);
        invoke.setModifiers(1);
        clazz.addMethod(invoke);
        Class iclass = TransformerCommon.toClass(clazz);
        Interceptor rtn = (Interceptor)iclass.newInstance();
        Field f = iclass.getField("aspectField");
        f.set(rtn, aspect);
        return rtn;
    }

    private static String getThreadStackBody(String optimized, Method advice, Method method) {
        String invokeBody = "public Object invoke(org.jboss.aop.joinpoint.Invocation invocation) throws java.lang.Throwable {     " + optimized + " optimized = (" + optimized + ")invocation; " + "   org.jboss.aop.joinpoint.CurrentInvocation.push(invocation); " + "   try {";
        invokeBody = invokeBody + "return ($w)aspectField." + advice.getName() + "(";
        Class<?>[] adviceParams = advice.getParameterTypes();
        Class<?>[] params = method.getParameterTypes();
        boolean first = true;
        if (adviceParams.length > 0) {
            int adviceParam = 0;
            for (int i = 0; i < params.length && adviceParam < adviceParams.length; ++i) {
                if (!adviceParams[adviceParam].equals(params[i])) continue;
                ++adviceParam;
                if (first) {
                    first = false;
                } else {
                    invokeBody = invokeBody + ", ";
                }
                invokeBody = invokeBody + "optimized.arg" + i;
            }
        }
        invokeBody = invokeBody + "); ";
        invokeBody = invokeBody + "   } finally { org.jboss.aop.joinpoint.CurrentInvocation.pop(); }";
        invokeBody = invokeBody + "}";
        return invokeBody;
    }

    private static String getInvocationBody(String optimized, Method advice, Method method) {
        String invokeBody = "public Object invoke(org.jboss.aop.joinpoint.Invocation invocation) throws java.lang.Throwable {     " + optimized + " optimized = (" + optimized + ")invocation; " + "   return ($w)aspectField." + advice.getName() + "(optimized";
        Class<?>[] adviceParams = advice.getParameterTypes();
        Class<?>[] params = method.getParameterTypes();
        if (adviceParams.length > 0) {
            int adviceParam = 1;
            for (int i = 0; i < params.length && adviceParam < adviceParams.length; ++i) {
                if (!adviceParams[adviceParam].equals(params[i])) continue;
                ++adviceParam;
                invokeBody = invokeBody + ", ";
                invokeBody = invokeBody + "optimized.arg" + i;
            }
        }
        invokeBody = invokeBody + "); ";
        invokeBody = invokeBody + "}";
        return invokeBody;
    }
}

