/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.Domain;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.InstanceAdvisorDelegate;
import org.jboss.aop.InterceptorChainObserver;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.metadata.SimpleMetaData;

public class GeneratedInstanceAdvisorMixin
implements InstanceAdvisor,
Serializable {
    static final long serialVersionUID = -3057976129116723527L;
    protected ArrayList insertedInterceptors = null;
    protected ArrayList appendedInterceptors = null;
    protected Object instance;
    public boolean hasInstanceAspects = false;
    private InterceptorChainObserver interceptorChainObserver;
    InstanceAdvisorDelegate delegate;

    public GeneratedInstanceAdvisorMixin() {
    }

    public GeneratedInstanceAdvisorMixin(Object instance, GeneratedClassAdvisor genadvisor) {
        this.instance = instance;
        this.delegate = new InstanceAdvisorDelegate(genadvisor, this);
        this.delegate.initialize();
        this.interceptorChainObserver = genadvisor.getInterceptorChainObserver();
    }

    public boolean hasInterceptors() {
        return this.appendedInterceptors != null || this.insertedInterceptors != null;
    }

    public Object getPerInstanceAspect(String def) {
        return this.delegate.getPerInstanceAspect(def);
    }

    public Object getPerInstanceAspect(AspectDefinition def) {
        return this.delegate.getPerInstanceAspect(def);
    }

    public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def) {
        return this.delegate.getPerInstanceJoinpointAspect(joinpoint, def);
    }

    public SimpleMetaData getMetaData() {
        return this.delegate.getMetaData();
    }

    public Interceptor[] getInterceptors() {
        Iterator it;
        ArrayList<Interceptor> newlist = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            it = this.insertedInterceptors.iterator();
            while (it.hasNext()) {
                newlist.add(((GeneratedAdvisorInterceptor)it.next()).create(null, null));
            }
        }
        if (this.appendedInterceptors != null) {
            it = this.appendedInterceptors.iterator();
            while (it.hasNext()) {
                newlist.add(((GeneratedAdvisorInterceptor)it.next()).create(null, null));
            }
        }
        return newlist.toArray(new Interceptor[newlist.size()]);
    }

    public Interceptor[] getInterceptors(Interceptor[] advisorChain) {
        Iterator it;
        if (this.insertedInterceptors == null && this.appendedInterceptors == null) {
            return advisorChain;
        }
        ArrayList<Interceptor> newlist = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            it = this.insertedInterceptors.iterator();
            while (it.hasNext()) {
                newlist.add(((GeneratedAdvisorInterceptor)it.next()).create(null, null));
            }
        }
        if (advisorChain != null) {
            newlist.addAll(Arrays.asList(advisorChain));
        }
        if (this.appendedInterceptors != null) {
            it = this.appendedInterceptors.iterator();
            while (it.hasNext()) {
                newlist.add(((GeneratedAdvisorInterceptor)it.next()).create(null, null));
            }
        }
        return newlist.toArray(new Interceptor[newlist.size()]);
    }

    public GeneratedAdvisorInterceptor[] getWrappers() {
        ArrayList newlist = new ArrayList();
        if (this.insertedInterceptors != null) {
            newlist.addAll(this.insertedInterceptors);
        }
        if (this.appendedInterceptors != null) {
            newlist.addAll(this.appendedInterceptors);
        }
        return newlist.toArray(new GeneratedAdvisorInterceptor[newlist.size()]);
    }

    public Interceptor[] getWrappers(Interceptor[] advisorChain) {
        if (this.insertedInterceptors == null && this.appendedInterceptors == null) {
            return advisorChain;
        }
        ArrayList<Interceptor> newlist = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            newlist.addAll(this.insertedInterceptors);
        }
        if (advisorChain != null) {
            newlist.addAll(Arrays.asList(advisorChain));
        }
        if (this.appendedInterceptors != null) {
            newlist.addAll(this.appendedInterceptors);
        }
        return newlist.toArray(new GeneratedAdvisorInterceptor[newlist.size()]);
    }

    public void insertInterceptor(int index, Interceptor interceptor) {
        ArrayList<GeneratedAdvisorInterceptor> newList = new ArrayList<GeneratedAdvisorInterceptor>();
        if (this.insertedInterceptors != null) {
            newList.addAll(this.insertedInterceptors);
        }
        newList.add(index, this.createWrapper(interceptor));
        this.insertedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void insertInterceptor(Interceptor interceptor) {
        ArrayList<GeneratedAdvisorInterceptor> newList = new ArrayList<GeneratedAdvisorInterceptor>();
        if (this.insertedInterceptors != null) {
            newList.addAll(this.insertedInterceptors);
        }
        newList.add(this.createWrapper(interceptor));
        this.insertedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void appendInterceptor(Interceptor interceptor) {
        ArrayList<GeneratedAdvisorInterceptor> newList = new ArrayList<GeneratedAdvisorInterceptor>();
        if (this.appendedInterceptors != null) {
            newList.addAll(this.appendedInterceptors);
        }
        newList.add(this.createWrapper(interceptor));
        this.appendedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void appendInterceptor(int index, Interceptor interceptor) {
        ArrayList<GeneratedAdvisorInterceptor> newList = new ArrayList<GeneratedAdvisorInterceptor>();
        if (this.appendedInterceptors != null) {
            newList.addAll(this.appendedInterceptors);
        }
        newList.add(index, this.createWrapper(interceptor));
        this.appendedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void removeInterceptor(String name) {
        int interceptorsRemoved = this.internalRemoveInterceptor(name);
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
        }
    }

    private int internalRemoveInterceptor(String name) {
        ArrayList newList;
        GeneratedAdvisorInterceptor interceptor;
        int i;
        int interceptorsRemoved = 0;
        if (this.insertedInterceptors != null) {
            for (i = 0; i < this.insertedInterceptors.size(); ++i) {
                interceptor = (GeneratedAdvisorInterceptor)this.insertedInterceptors.get(i);
                if (!interceptor.getName().equals(name)) continue;
                newList = new ArrayList();
                newList.addAll(this.insertedInterceptors);
                newList.remove(i);
                this.insertedInterceptors = newList;
                ++interceptorsRemoved;
            }
        }
        if (this.appendedInterceptors != null) {
            for (i = 0; i < this.appendedInterceptors.size(); ++i) {
                interceptor = (GeneratedAdvisorInterceptor)this.appendedInterceptors.get(i);
                if (!interceptor.getName().equals(name)) continue;
                newList = new ArrayList();
                newList.addAll(this.appendedInterceptors);
                newList.remove(i);
                this.appendedInterceptors = newList;
                ++interceptorsRemoved;
            }
        }
        this.hasInstanceAspects = this.insertedInterceptors != null && this.insertedInterceptors.size() > 0 || this.appendedInterceptors != null && this.appendedInterceptors.size() > 0;
        return interceptorsRemoved;
    }

    public final boolean hasAspects() {
        return this.hasInstanceAspects;
    }

    public void insertInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.instance instanceof Advised) {
            Advised advised = (Advised)this.instance;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsAdded = 0;
        for (InterceptorFactory factory : stack.getInterceptorFactories()) {
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create(classAdvisor, null);
            this.insertInterceptor(interceptor);
            ++interceptorsAdded;
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
        }
    }

    public void appendInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.instance instanceof Advised) {
            Advised advised = (Advised)this.instance;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsAdded = 0;
        for (InterceptorFactory factory : stack.getInterceptorFactories()) {
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create(classAdvisor, null);
            this.appendInterceptor(interceptor);
            ++interceptorsAdded;
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
        }
    }

    public void removeInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        if (this.instance instanceof Advised) {
            Advised advised = (Advised)this.instance;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsRemoved = 0;
        for (InterceptorFactory factory : stack.getInterceptorFactories()) {
            if (!factory.isDeployed()) continue;
            Interceptor interceptor = factory.create(classAdvisor, null);
            interceptorsRemoved += this.internalRemoveInterceptor(interceptor.getName());
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
        }
    }

    public Domain getDomain() {
        throw new RuntimeException("Should be handled by generated advisors");
    }

    protected void finalize() {
        block3: {
            block2: {
                ClassLoader classLoader = this.delegate.getAdvisor().getClazz().getClassLoader();
                if (this.interceptorChainObserver == null) break block2;
                this.delegate.getAdvisor().getManager();
                if (AspectManager.getRegisteredCLs().containsKey(classLoader)) break block3;
            }
            return;
        }
        this.interceptorChainObserver.allInstanceInterceptorsRemoved(this);
    }

    private GeneratedAdvisorInterceptor createWrapper(Interceptor interceptor) {
        return new GeneratedAdvisorInterceptor(new InstanceInterceptorFactory(interceptor), null, null);
    }

    public class InstanceInterceptorFactory
    implements InterceptorFactory {
        private Interceptor interceptor;

        private InstanceInterceptorFactory(Interceptor interceptor) {
            this.interceptor = interceptor;
        }

        public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
            return this.interceptor;
        }

        public String getClassName() {
            return this.interceptor.getClass().getName();
        }

        public String getAdvice() {
            return "invoke";
        }

        public AspectDefinition getAspect() {
            return null;
        }

        public String getName() {
            return this.interceptor.getName();
        }

        public boolean isDeployed() {
            return true;
        }
    }
}

