/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.joinpoint.ConstructorJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.util.MethodHashing;

public class ConstructorInfo
extends JoinPointInfo {
    private Method wrapper;
    private Constructor constructor;
    private int index;

    public ConstructorInfo() {
    }

    public ConstructorInfo(Class clazz, int index, long wrapperHash, long constructorHash, Advisor advisor) {
        super(advisor, clazz);
        try {
            this.index = index;
            this.wrapper = MethodHashing.findMethodByHash(clazz, wrapperHash);
            this.constructor = MethodHashing.findConstructorByHash(clazz, constructorHash);
            this.setAdvisor(advisor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ConstructorInfo(ConstructorInfo other) {
        super(other);
    }

    protected Joinpoint internalGetJoinpoint() {
        return new ConstructorJoinpoint(this.constructor);
    }

    public JoinPointInfo copy() {
        return new ConstructorInfo(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Constructor");
        sb.append("[");
        sb.append("constructor=" + this.constructor);
        sb.append("]");
        return sb.toString();
    }

    public void setWrapper(Method wrapper) {
        this.wrapper = wrapper;
    }

    public Method getWrapper() {
        return this.wrapper;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }
}

